<?php
require_once __DIR__ . '/vendor/autoload.php';
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Verificar Produtor de PDF</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #f4f4f9;
      color: #333;
      margin: 0;
      padding: 0;
    }
    .container {
      max-width: 700px;
      margin: 50px auto;
      padding: 20px;
      background: #fff;
      box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
      border-radius: 8px;
    }
    h1 {
      text-align: center;
      color: #0056b3;
    }
    label {
      display: block;
      margin: 20px 0 10px;
      font-weight: bold;
    }
    input[type="file"] {
      padding: 5px;
      width: 100%;
    }
    .modal {
      display: none;
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: rgba(0, 0, 0, 0.5);
      justify-content: center;
      align-items: center;
    }
    .modal-content {
      background: #fff;
      padding: 20px;
      border-radius: 8px;
      box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
      text-align: center;
    }
    .modal-content h2 {
      margin: 0 0 10px;
    }
    .modal-content button {
      margin-top: 10px;
      padding: 10px 20px;
      border: none;
      background-color: #0056b3;
      color: white;
      border-radius: 4px;
      cursor: pointer;
    }
    .modal-content button:hover {
      background-color: #003d80;
    }
    .sponsors {
      display: flex;
      justify-content: space-between;
      gap: 20px;
      margin: 30px 0;
    }
    .sponsor {
      flex: 1;
      padding: 20px;
      background: linear-gradient(135deg, #0056b3, #0099ff);
      border-radius: 12px;
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
      text-align: center;
      color: #fff;
      transition: transform 0.3s, box-shadow 0.3s;
    }
    .sponsor:hover {
      transform: translateY(-5px);
      box-shadow: 0 6px 12px rgba(0, 0, 0, 0.3);
    }
    .sponsor img {
      max-width: 100%;
      height: auto;
      border-radius: 8px;
      margin-bottom: 10px;
      border: 2px solid #fff;
    }
    .sponsor p {
      margin: 10px 0 0;
      font-size: 1.1em;
      font-weight: bold;
    }
    .socials {
      margin-top: 40px;
      text-align: center;
    }
    .socials a {
      margin: 0 10px;
      text-decoration: none;
      display: inline-block;
    }
    .socials a img {
      width: 40px;
      height: 40px;
      transition: transform 0.3s;
    }
    .socials a img:hover {
      transform: scale(1.2);
    }
  </style>
</head>
<body>
  <div class="container">
    <h1>Verificado</h1>
    <label for="pdfFile">Selecione um comprovativo em PDF:</label>
    <input type="file" id="pdfFile" accept="application/pdf" />

    <div class="sponsors">
      <div class="sponsor">
        <img src="imgVerificador/367734362_6545594798890070_6416823727582877390_n.jpeg">
        <p>SmartSchool</p>
      </div>
      <div class="sponsor">
        <img src="imgVerificador/7770575259_1730326590.jpeg" alt="Patrocinador 3">
        <p>Marpine</p>
      </div>
      <div class="sponsor">
        <img src="imgVerificador/7685236708_1730327160.20.44.jpeg" alt="Patrocinador 2">
        <p>Psicologia nas Comunidades</p>
      </div>
    </div>

    <div class="socials">
      <p>Nos siga nas redes sociais:</p>
      <a href="https://web.facebook.com/paulo.sermao" target="_blank">
        <img src="https://cdn-icons-png.flaticon.com/512/733/733547.png" alt="Facebook">
      </a>
      <a href="https://www.instagram.com/paulo_sermao/" target="_blank">
        <img src="https://cdn-icons-png.flaticon.com/512/733/733558.png" alt="Instagram">
      </a>
      <a href="https://www.linkedin.com/in/paulo-serm%C3%A3o-2a96411b6/" target="_blank">
        <img src="https://cdn-icons-png.flaticon.com/512/733/733561.png" alt="LinkedIn">
      </a>
      <a href="https://www.tiktok.com/@paulosermao" target="_blank">
        <img src="https://cdn-icons-png.flaticon.com/512/3046/3046121.png" alt="TikTok">
      </a>
    </div>
  </div>

  <!-- Modal -->
  <div class="modal" id="modal">
    <div class="modal-content">
      <h2 id="modalMessage"></h2>
      <button onclick="closeModal()">Fechar</button>
    </div>
  </div>

  <!-- Importando a biblioteca PDF.js -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.16.105/pdf.min.js"></script>
  <script>
    const TARGET_PRODUCER = "iText® 7.0.5 ©2000-2017 iText Group NV (AGPL-version); modified using iText® 5.5.13.3 ©2000-2022 iText Group NV (AGPL-version)";
    const modal = document.getElementById("modal");
    const modalMessage = document.getElementById("modalMessage");

    document.getElementById('pdfFile').addEventListener('change', async (event) => {
      const file = event.target.files[0];
      if (file && file.type === 'application/pdf') {
        const reader = new FileReader();
        reader.onload = async (e) => {
          const arrayBuffer = e.target.result;

          try {
            // Carregando o PDF
            const pdf = await pdfjsLib.getDocument({ data: arrayBuffer }).promise;

            // Lendo os metadados
            const metadata = await pdf.getMetadata();
            const producer = metadata.info?.Producer || "Não disponível";

            // Verificando o produtor
            if (producer === TARGET_PRODUCER) {
              showModal("Comprovativo verdadeiro foi gerado no Express");
            } else {
              showModal("O documento não foi gerado no Express");
            }
          } catch (err) {
            showModal(`Erro ao processar o arquivo: ${err.message}`);
          }
        };
        reader.readAsArrayBuffer(file);
      } else {
        alert('Por favor, selecione um arquivo PDF válido.');
      }
    });

    function showModal(message) {
      modalMessage.textContent = message;
      modal.style.display = "flex";
    }

    function closeModal() {
      modal.style.display = "none";
    }
  </script>
</body>
</html>
